/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class QDButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Border m_normalBorder;
    private Border m_pressedBorder;
    private Boolean m_pressing = false;
    private boolean m_mouseOver = false;
    private boolean m_isTight = true;

    public QDButton() {
        this.initLook();
    }

    public QDButton(Icon icon) {
        super(icon);
        this.initLook();
    }

    public QDButton(String string) {
        super(string);
        this.initLook();
    }

    public QDButton(Action action) {
        super(action);
        this.initLook();
    }

    public QDButton(String string, Icon icon) {
        super(string, icon);
        this.initLook();
    }

    public void useSmallFont(boolean bl) {
        if (bl) {
            this.setFont(QDStdUI.getSmallActionFont());
        } else {
            this.setFont(QDStdUI.getActionFont());
        }
    }

    public void setTightBorder(boolean bl) {
        if (bl == this.m_isTight) {
            return;
        }
        this.m_isTight = bl;
        if (this.m_isTight) {
            this.m_normalBorder = QDStdUI.getRaisedBorder();
            this.m_pressedBorder = QDStdUI.getLoweredBorder();
        } else {
            Border border = BorderFactory.createEmptyBorder(3, 5, 3, 5);
            Border border2 = QDStdUI.getRaisedBorder();
            this.m_normalBorder = BorderFactory.createCompoundBorder(border2, border);
            border2 = QDStdUI.getLoweredBorder();
            this.m_pressedBorder = BorderFactory.createCompoundBorder(border2, border);
        }
    }

    private void initLook() {
        this.setFont(QDStdUI.getActionFont());
        this.setForeground(QDStdUI.getActionForeground());
        this.setBackground(QDStdUI.getActionBackground());
        this.setMargin(QDStdUI.getActionInsets());
        this.setBorderPainted(true);
        this.setFocusable(true);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setTightBorder(false);
        this.setBorder(this.m_normalBorder);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                QDButton.this.m_pressing = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                QDButton.this.m_pressing = false;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                QDButton.this.m_mouseOver = true;
                QDButton.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                QDButton.this.m_mouseOver = false;
                QDButton.this.repaint();
            }
        });
    }

    public void paint(Graphics graphics) {
        GradientPaint gradientPaint;
        if (this.m_pressing.booleanValue()) {
            if (this.m_mouseOver) {
                this.setBorder(this.m_pressedBorder);
            } else {
                this.setBorder(this.m_normalBorder);
            }
            graphics.setColor(Color.lightGray);
            this.setForeground(Color.BLACK);
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonDark(), 0.0f, this.getHeight(), QDStdUI.getButtonLight());
        } else {
            this.setBorder(this.m_normalBorder);
            if (this.m_mouseOver) {
                this.setForeground(QDStdUI.getFocusColor());
            } else {
                this.setForeground(Color.BLACK);
            }
            graphics.setColor(QDStdUI.getActionBackground());
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonLight(), 0.0f, this.getHeight(), QDStdUI.getButtonDark());
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setPaint(paint);
        if (this.isFocusOwner() && !this.m_pressing.booleanValue()) {
            Color color = this.m_pressing != false ? Color.black : QDStdUI.getFocusColor();
            graphics.setColor(color);
            graphics.drawRect(4, 4, this.getWidth() - 8, this.getHeight() - 8);
        }
        super.paint(graphics);
    }
}

